S = 10 # concentration of resource in input medium
b = 1 # conversion efficiency
R_star_lo = 1 # lowest possible R* value
R_star_hi = 10 # highest possible R* value
ns = 1:10 # range of species richness to try
n_rep = 100 # number of repeats

# matrices to store the results
all_ns = matrix(rep(ns,n_rep),length(ns),n_rep)
all_Bs = matrix(0,length(ns),n_rep)

for ( i in 1:length(ns) )
  {
  n = ns[i] # get number of species
  for ( j in 1:n_rep )
    {
    # draw the R* values for n species 
    R_stars = runif(n,R_star_lo,R_star_hi)
    # determine final biomass
    all_Bs[i,j] = b*(S-min(R_stars))
    }
  }

plot(all_ns,all_Bs,pch=19,xlab='n',ylab='B')
E_Bs = b*(S-R_star_lo-(R_star_hi-R_star_lo)/(ns+1))
lines(ns,E_Bs,col='red') 
